# Vespucci 17.1 Highlights

2022-06-01
  
### Bing imagery no longer available for 3rd-party builds

Since we added Bing support over a decade ago, the API key to access the service has been included with the source code for third parties to use, most notably F-Droid as a courtesy. Starting with this version this is no longer the case as allowing access to a wide range of sources is considered an anti-feature by the operators of F-Droid, see [Vespucci on F-Droid](https://f-droid.org/en/packages/de.blau.android/).

With other words starting with version 17.1 Bing imagery will no longer be available for F-Droid users. If you have your own key, you can load it via the [_Tools_ menu](http://vespucci.io/help/en/Main%20map%20display/#available-actions), just as any other key. See the [default key file]( https://github.com/MarcusWolschon/osmeditor4android/blob/master/src/main/assets/keys2-default.txt) and [test key file](https://github.com/MarcusWolschon/osmeditor4android/blob/master/src/test/resources/keys2.txt) for the format and an example.

It should be noted that the other claims by F-Droid in this context are incorrect, neither Mapillary support or Github access has ever been available in 3rd-party builds of Vespucci.

### Updated privacy policy / ability to remove API keys

Using Bing imagery requires querying a Bing API to obtain some meta data prior to use, as this is very slow we have always done this asynchronously and independent of the user actually using the specific source. We've updated the privacy policy to note this and have provided a way to completely disable the Bing source, see [Installation FAQ](http://vespucci.io/tutorials/faq/#installation).

It should be further noted that a number of the layer configurations from the [Editor Layer Index](https://github.com/osmlab/editor-layer-index) reference (via Url) icons that are stored in the ELI repository. This implies that using such layers doesn't just provide a certain amount of personal information to the operator of the source, but that a small amount of PI is leaked to github and its owner (Microsoft).

### _Auto_ full screen mode on Android 11 and later behaviour change

On Android 11 and later the default _Auto_ mode for the full screen mode preference will never enable full screen mode as navigation gestures provide a viable alternative and googles and subcontractors full screen support has become even less predictable than on earlier versions. 

If you are using a device that previously had full screen mode automatically turned on and that is now disabled, you can force the use of full screen mode by setting the preference to _Force_.

### Improved GPX layer support

The GPX layer has been reworked to allow multiple individual layers that can be created by either loading a GPX file from device or downloading from the OSM website. Some additional functionality has been implemented per layer, see [layer control](http://vespucci.io/help/en/Main%20map%20display/#layer-control) and some more styling options have been added.

### Preset improvements

Previously Vespucci assumed a single level hierarchy of keys to match as "real-life" objects, for example all "highway" keys were assumed to define an object. Unluckily in real life this doesn't always lead to satisfactory results, for example _cycleway=asl_.  This version adds a further attribute to the preset configuration that allows to define exceptions to the hierarchy, for more information see the [preset documentation](http://vespucci.io/tutorials/presets/#extensions).    

Preset items and tags that have the "deprecated" attribute are now automatically indicated. This removes the need to add this to the text of the items or tags. To make this work preset items can now have the same name, this doesn't just work for deprecated items, but for example for country specific presets.

In version 15.1 we added a menu item in the property editor to display a modal with alternative tagging suggestions for the current object, this has been replaced with a display of the alternative preset items (if any exist) above the _most recently used_ preset list.

Version 17.1 further adds support for [large images in presets](https://twitter.com/vespucci_editor/status/1505931569139265539) this can make selection of a specific tag value easier by supply visual examples. An example preset [_bicycle parking_](http://vespucci.io/help/en/Presets/#useful-presets-for-download) with large images is available for download.

To make adding presets from the JOSM preset list even easier we now re-write urls from that page in the _Preset help_ on device to auto-download an install Uris. 

### Way rendering improvements

Previously area rendering (both simple and multi-polygons) utilized offset patterns to indicate the "inside" of the object. This has now been replaced in most cases by an offset of the line, this reduces artifacts and avoids some of the performance issues the previous solution had.

The offset functionality has the additional benefit that it allows offset casing of ways, an example of this can be found in the rendering of _highway=residential_ that now indicates if sidewalk have been tagged (left, right or on both sides). 

### Upload reminder

If you exit the app with unpublished changes you will receive a reminder notification in regular intervals. THe default interval is 6 hours, but this can be set to very high values essentially disabling it for practical purposes. See [user interface settings](http://vespucci.io/help/en/Advanced%20preferences/#user-interface-settings).

### Include Androids MediaStore in scan for images

You can now optionally scan the MediaStore for images. This is mainly useful on Android 10 and higher which doesn't allow direct access to images owned by other apps any more. As this will include _all_ images in the MediaStore that contain location information this is turned off by default. See See [user interface settings](http://vespucci.io/help/en/Advanced%20preferences/#user-interface-settings).

### Automatic capitalization of name tags

We now automatically capitalize _name_ tags on input for latin script. The setting for this can be changed to one off _No capitalization_ , _Word capitalization_ and _Sentence capitalization_ . The default is _Word capitalization_ .

## Miscellaneous
 
- Expand the "screenshot" page on vespucci.io to include videos.
- Support for version, short description and description in presets.
- Use josm scheme instead of localhost for alert intents (workaround google change for Android 12).
- Allow editing of new note comments that have been saved but not uploaded.
- Add preferences to individually enable/disable validations.
- Add validation for non-standard element type.
- Add multi-threaded GPX draw for large/long GPX tracks. Thanks to  https://github.com/kai-morich !
- Handle error conditions due to the new relation member limit for the OSM API being reached.
- Add function to select way nodes.

# Upgrading from previous versions

* As the saved state file has changed you should upload any pending changes before updating.

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
